@echo off
chcp 65001 >nul
echo ██ AScript-ESP蓝牙固件烧录工具 For Windows (2025) ██
echo 确认将芯片连接至电脑

:refresh_ports
echo 正在扫描可用的COM端口...
echo.

:: 列出所有COM端口
mode | find "COM" >nul
if %errorlevel% equ 0 (
    echo 可用的COM端口：
    mode | find "COM"
) else (
    echo 未找到可用的COM端口！
)

echo.

:: 手动指定COM端口
::set PORT=COM4

set /p PORT=请输入ESP32-S3设备的COM端口（例如COM3,可打开设备管理器 》端口 查看，或输入R刷新列表）： 

:: 检查用户是否输入了内容
if "%PORT%"=="" (
    echo 错误：未输入COM端口！
    pause
    exit /b
)

:: 如果用户输入了R，刷新端口列表
if /i "%PORT%"=="R" (
    goto refresh_ports
)

echo 检测到设备：%PORT%
echo.

echo 请确认设备已连接并进入下载模式（按住BOOT键点击EN键）。
pause

:: 设置固件文件路径
set FIRMWARE_DIR=firmware
set BOOTLOADER=%FIRMWARE_DIR%\bootloader.bin
set PARTITIONS=%FIRMWARE_DIR%\partitions.bin
set FIRMWARE=%FIRMWARE_DIR%\firmware.bin

echo 当前工作目录：%cd%
echo 固件目录：%FIRMWARE_DIR%
echo bootloader.bin 路径：%BOOTLOADER%
echo partitions.bin 路径：%PARTITIONS%
echo firmware.bin 路径：%FIRMWARE%

:: 检查固件文件是否存在
if not exist "%BOOTLOADER%" (
    echo 错误：未找到 bootloader.bin 文件！
    echo 请确认固件文件路径：%FIRMWARE_DIR%
    pause
    exit /b
)
if not exist "%PARTITIONS%" (
    echo 错误：未找到 partitions.bin 文件！
    echo 请确认固件文件路径：%FIRMWARE_DIR%
    pause
    exit /b
)
if not exist "%FIRMWARE%" (
    echo 错误：未找到 firmware.bin 文件！
    echo 请确认固件文件路径：%FIRMWARE_DIR%
    pause
    exit /b
)

:: 执行烧录（修改为ESP32-S3的烧录命令）
echo 正在烧录到 %PORT% ...
python -m esptool --chip esp32s3 -p %PORT% -b 921600 --before=no_reset --after=hard_reset write_flash ^
0x0 "%BOOTLOADER%" ^
0x8000 "%PARTITIONS%" ^
0x10000 "%FIRMWARE%"

if %errorlevel% equ 0 (
    echo --------------------------------------------------
    echo 烧录成功！设备已执行硬件复位。
    echo --------------------------------------------------
    echo.
    timeout /t 2 /nobreak >nul
    echo 尝试发送运行命令...
    python -m esptool -p %PORT% run
    echo.
    echo 如果设备未自动运行或串口/蓝牙无响应，请手动按一下 RST/EN 按钮。
) else (
    echo 错误：烧录失败！请检查接线
)
pause